# Default Diffusion Project

This repository contains code for the Default Diffusion Project, which is part of final project of the EE367 course. The project includes several Jupyter notebooks that demonstrate different aspects of diffusion processes.

## Note

The pre-trained diffusion model `models/ffhq_10m.pt` has been removed to reduce the folder size. To reproduce the results, please download `ffhq_10m.pt` and save it in the `models/` directory as `models/ffhq_10m.pt`.

## Notebooks

### task2.ipynb
This notbook implement single-step image denoising using a pre-trained diffusion model.

### task3.ipynb
In this notebook, we implement unconditional image generation using a pre-trained DDPM.

### task4.ipynb
This notebook focuses on SDEdit (Score-Distillation Editing) using a pre-trained DDPM.

### task5.ipynb
Here, we implement ScoreALD using a pre-trained DDPM to solve inverse problems like image inpainting and deconvolution.

### task6.ipynb
The final notebook presents Diffusion Posterior Sampling (DPS) using a pre-trained DDPM to solve inverse problems like image inpainting and deconvolution.

## Getting Started

To run the notebooks, you need to activate conda environment ee367-project:

```bash
conda activate ee367-project
```

Open the desired notebook (e.g., `task2.ipynb`) in your browser and follow the instructions provided.

## Acknowledgments

This project is part of the EE367 course at Stanford University. Special thanks to the course instructors and teaching assistants for their support and guidance.
